#ifndef CE2_RSA_TYPES_H
#define CE2_RSA_TYPES_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CE2_RSA_Types.h    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:42:30 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions 
   *         that are used for the CE2 AES APIs, as well as the APIs themselves.
   *
   *  \version CE2_AES.h#1:incl:13
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/

/* The valid key size in bits */
#define CE2_RSA_MIN_VALID_KEY_SIZE_VALUE_IN_BITS      512
#define CE2_RSA_MAX_VALID_KEY_SIZE_VALUE_IN_BITS      2112
#define CE2_RSA_VALID_KEY_SIZE_MULTIPLE_VALUE_IN_BITS 32

/* If the salt length is not available in verify than the user can use this define and the algorithm will */
/* calculate the salt length alone*/
/* Security Note: it is recommended not to use this flag and to support the Salt length on each verify*/
#define CE2_RSA_VERIFY_SALT_LENGTH_UNKNOWN             0xFFFF

/* The minimum exponent size */
#define CE2_RSA_MIN_PUB_EXP_VALUE  3
#define CE2_RSA_MIN_PRIV_EXP_VALUE 1

/* The maximum buffer size for the 'H' value */
#define CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS ((CE2_RSA_MAX_VALID_KEY_SIZE_VALUE_IN_BITS + 64UL ) / 32 )

/* The possible hash modes are SHA-1 and MD5, as defined in CE2_HASH.h */
#define CE2_PKCS1_HashFunc_t CE2_HASH_OperationMode_t

/* TBD */

#define CE2_RSA_OAEP_MAX_HLEN							CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES

/* MGF1 declarations */
#define CE2_RSA_MGF_2_POWER_32              			65535 /* 0xFFFF */ /* 0x100000000 */ /* This is the 2^32 of the 2^32*hLen boundary check */
#define CE2_RSA_SIZE_OF_T_STRING_BYTES	    			(CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS*sizeof(DxUint32_t)) /* Buffer inside RSA context */

/***********************************************************
 *
 * RSA PKCS#1 v2.1 DEFINES
 *
 ***********************************************************/     
#define CE2_RSA_OAEP_ENCODE_MAX_SEEDMASK_SIZE 			CE2_RSA_OAEP_MAX_HLEN
#define CE2_RSA_PSS_SALT_LENGTH 						CE2_RSA_OAEP_MAX_HLEN
#define CE2_RSA_PSS_PAD1_LEN							8
	 
#define CE2_RSA_OAEP_ENCODE_MAX_MASKDB_SIZE  			(CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS*sizeof(DxUint32_t)) /* For OAEP Encode; the max size is emLen */
#define CE2_RSA_OAEP_DECODE_MAX_DBMASK_SIZE  			(CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS*sizeof(DxUint32_t)) /* For OAEP Decode; the max size is emLen */

/************************ Enums ********************************/

/* Defines the enum for the HASH operation mode.
 * This enum differs from the one defined in CE2_HASH.h in that 
 * it is only for the CE2 level and enables SHA-1 and MD5 modes. 
 * The SSL modes are for PKCS1 v1.5 when the data given 
 * to the Sign operation is already hashed with SHA-1 or MD5.
 */
typedef enum
{
   CE2_RSA_HASH_MD5_mode  = 0,
   CE2_RSA_HASH_SHA1_mode = 1,
   CE2_RSA_HASH_SHA224_mode = 2,
   CE2_RSA_HASH_SHA256_mode = 3,
   CE2_RSA_HASH_SHA384_mode = 4,
   CE2_RSA_HASH_SHA512_mode = 5,
   CE2_RSA_After_MD5_mode = 6,		/* For PKCS1 v1.5 when the data is already hashed with MD5 */
   CE2_RSA_After_SHA1_mode = 7,	/* For PKCS1 v1.5 when the data is already hashed with SHA1 */
   CE2_RSA_After_SHA224_mode = 8,	/* For PKCS1 v1.5 when the data is already hashed with SHA224 */
   CE2_RSA_After_SHA256_mode = 9,	/* For PKCS1 v1.5 when the data is already hashed with SHA256 */
   CE2_RSA_After_SHA384_mode = 10,	/* For PKCS1 v1.5 when the data is already hashed with SHA384 */
   CE2_RSA_After_SHA512_mode = 11,	/* For PKCS1 v1.5 when the data is already hashed with SHA512 */
   CE2_RSA_After_HASH_NOT_KNOWN_mode = 12,    /*used only for PKCS#1 Ver 1.5 - possible to perform verify operation without hash mode input ; the hash mode will be derived from the signature*/
   CE2_RSA_HASH_NO_HASH_mode = 13,	/* Used for PKCS1 v1.5 Encrypt and Decrypt*/
   CE2_RSA_HASH_NumOfModes

}CE2_RSA_HASH_OpMode_t;   

typedef enum
{
	CE2_PKCS1_MGF1 = 0,
	CE2_PKCS1_NO_MGF = 1,
	CE2_RSA_NumOfMGFFunctions

}CE2_PKCS1_MGF_t;

/* PKCS1 version definitions */
typedef enum
{
  //CE2_PKCS1_Unknown = 0, 
  CE2_PKCS1_VER15	  = 0,
  CE2_PKCS1_VER21	  = 1,
  CE2_PKCS1_NumOfVersion
}CE2_PKCS1_version;

/********* Public and private key database Structs *************/

/**************** The public key definitions *******************/

/* The public key data structure */
typedef struct 
{ 
   /* The RSA modulus buffer and its size in bits */
   DxUint32_t n[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
   DxUint32_t nSizeInBits;
   
   /* The RSA public exponent buffer and its size in bits */
   DxUint32_t e[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
   DxUint32_t eSizeInBits; 
}CE2RSAPubKey_t;

/* The user structure prototype used as an input to the CE2_RSA_PRIM_Encrypt */
typedef struct CE2_RSAUserPubKey_t 
{
   DxUint32_t valid_tag;           
   DxUint8_t  PublicKeyDbBuff[ sizeof(CE2RSAPubKey_t) ]; 
}CE2_RSAUserPubKey_t;

/*************** The private key definitions *******************/

/* Defines mode of private key: non CRT or CRT
used in CE2RSAPrivKey_t structure */
#define CE2_RSA_PRIVATE_KEY_NON_CRT_MODE	0
#define CE2_RSA_PRIVATE_KEY_CRT_MODE		1

/* The private key data structure */
typedef struct
{ 
	/* The RSA public exponent buffer and its size in bits */
	DxUint32_t e[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t eSizeInBits;

	/* The RSA private exponent buffer and its size in bits */
	DxUint32_t d[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t dSizeInBits;

	/* The RSA modulus buffer and its size in bits */
	DxUint32_t n[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t nSizeInBits;

	/* The RSA p factor of modulus N buffer and its size in bits */
	DxUint32_t p[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t pSizeInBits;

	/* The RSA q factor of modulus N buffer and its size in bits */
	DxUint32_t q[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t qSizeInBits;

	/* The RSA 1/q mod p CRT param buffer and its size in bits */
	DxUint32_t qP[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t qPSizeInBits;

	/* The RSA d mod (p-1) CRT param buffer and its size in bits */
	DxUint32_t dP[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t dPSizeInBits;

	/* The RSA d mod (q-1) CRT param buffer and its size in bits */
	DxUint32_t dQ[CE2_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
	DxUint32_t dQSizeInBits;

	/* Key is in CRT mode: CRT values are filled (precalculated)
	used previous defined values */
	DxUint16_t mode;
}CE2RSAPrivKey_t;

/* The user structure prototype used as an input to the 
   CE2_RSA_PRIM_Decrypt or CE2_RSA_PRIM_DecryptCRT */
typedef struct CE2_RSAUserPrivKey_t 
{
   DxUint32_t valid_tag;           
   DxUint8_t  PrivateKeyDbBuff[ sizeof(CE2RSAPrivKey_t) ]; 

}CE2_RSAUserPrivKey_t;

#ifdef __cplusplus
}
#endif

#endif /* CE2_RSA_TYPES_H */
